
<?php $__env->startSection('titulo','Editar Área'); ?>

<?php $__env->startSection('content'); ?>

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Editar Área</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="<?php echo e(route('home')); ?>"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="<?php echo e(route('users.index')); ?>">Áreas</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Editar Área</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Datos del Área</h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas.create')): ?><a href="<?php echo e(route('areas.create')); ?>" class="btn btn-primary btn-round mr-2">Agregar Nueva Area</a><?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                <?php echo Form::model($area,['route'=>['areas.update',$area->id],'method'=>'PUT','class'=>'needs-validation']); ?>

                    <?php echo $__env->make('admin.areas._form',['texto' => 'Actualizar','color'=>'success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Administrar Unidades del Area</h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('unidades.create')): ?>
                        <button class="btn btn-primary btn-round" onclick="create();">Agregar Nueva Unidad</button>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-left mb-3">
                        <h1>Listado de Unidades dependientes del área <strong class="badge badge-warning"><?php echo e($area->unidades->count()); ?></strong> </h1>
                    </div>
                    
                    <input type="hidden" value="<?php echo e(auth()->user()->can('unidades.destroy')); ?>" id='can_destroy'>
                    <input type="hidden" value="<?php echo e(auth()->user()->can('unidades.edit')); ?>" id='can_edit'>
                    <input type="hidden" value="<?php echo e($area->id); ?>" id='area_id'>
                    <input type="hidden" value="<?php echo e($area->codigo); ?>" id='area_codigo'>
                    <p>En campo <strong>ORDEN</strong> se utiliza para ordenar las unidades dependientes dentro del área al momento de mostrar el directorio de empleados</p>
                    <div class="table-responsive" width="100%">
                        <table class="table table-hover table-sm" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">Código</th>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Área</th>
                                    <th class="text-center">Orden</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.areas._modal_unidad', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?> 
    <script src="<?php echo e(asset('assets/js/forms/crudUnidades.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/admin/areas/edit.blade.php ENDPATH**/ ?>