
<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>Login</title>
	<meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
	<link rel="icon" href="../assets/img/icon.ico" type="image/x-icon"/>

	<!-- Fonts and icons -->
	<script src="../assets/js/plugin/webfont/webfont.min.js"></script>
	<script>
		WebFont.load({
			google: {"families":["Lato:300,400,700,900"]},
			custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['../assets/css/fonts.min.css']},
			active: function() {
				sessionStorage.fonts = true;
			}
		});
	</script>
	
	<!-- CSS Files -->
	<link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets_login/css/atlantis_register.css')); ?>">
</head>
<body class="login">
	<div class="wrapper wrapper-login wrapper-login-full p-0">
		<div class="login-aside w-50 d-flex flex-column align-items-center justify-content-center text-center bg-primary-gradient">
			<h1 class="title fw-bold text-white mb-3">Bienvenid@ al Intranet del Sedem</h1>
			<p class="subtitle text-white op-7">Para habilitar su acceso al sistema debe complementar la información del formulario. Se realizará la verificación de sus datos con RRHH y se procedera con su habilitación enviando las credenciales de acceso a su correo institucional.</p>
		</div>
		<div class="login-aside w-50 d-flex align-items-center justify-content-center bg-white">
			<div class="container container-login container-transparent animated fadeIn">
				<h3 class="text-center">formulario de Solicitud de Habilitación de Acceso</h3>
				<?php if($errors->any()): ?>
                    <ul style="list-style: none; " class="alert-danger">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-danger"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
				<form method="POST" action="<?php echo e(route('register')); ?>">
					<?php echo csrf_field(); ?>
					<div class="login-form">
						<div class="form-group <?php echo e($errors->has('ci') ? 'has-error' : ''); ?>"">
							<label for="ci" class="placeholder"><b>Número de C.I.</b></label>
							<input  id="ci" name="ci" type="text" class="form-control">
						</div>
						<div class="form-group <?php echo e($errors->has('name') ? 'has-error' : ''); ?>"">
							<label for="name" class="placeholder"><b>Apellidos y Nombres</b></label>
							<input  id="name" name="name" type="text" class="form-control" onkeyup="javascript:this.value=this.value.toUpperCase();">
						</div>
						<div class="form-group <?php echo e($errors->has('email') ? 'has-error' : ''); ?>"">
							<label for="email" class="placeholder"><b>Correo Institucional</b></label>
							<input  id="email" name="email" type="email" class="form-control">
						</div>
						<div class="form-group <?php echo e($errors->has('cargo') ? 'has-error' : ''); ?>"">
							<label for="cargo" class="placeholder"><b>Cargo</b></label>
							<input id="cargo" name="cargo" type="text" class="form-control" onkeyup="javascript:this.value=this.value.toUpperCase();">
						</div>
						<div class="form-group <?php echo e($errors->has('lugar_trabajo') ? 'has-error' : ''); ?>"">
							<label for="lugar_trabajo" class="placeholder"><b>Lugar de Trabajo (Piso / Unidad) si se encuentra en el interior indique en que departamento.</b></label>
							<input id="lugar_trabajo" name="lugar_trabajo" type="text" class="form-control" onkeyup="javascript:this.value=this.value.toUpperCase();">
						</div>
						<div class="form-group <?php echo e($errors->has('nro_celular') ? 'has-error' : ''); ?>"">
							<label for="nro_celular" class="placeholder"><b>Número de Celular</b></label>
							<input id="nro_celular" name="nro_celular" type="text" class="form-control validar">
						</div>
						<div class="form-group <?php echo e($errors->has('unidad_id') ? 'has-error' : ''); ?>"">
							<label for="unidad_id" class="placeholder"><b>Unidad a la que pertenece</b></label>
							<select name="unidad_id" id="unidad_id" class="form-control">
								<option value="">-- BUSQUE Y SELECCIONE --</option>
								<?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($unidad->id); ?>"><?php echo e($unidad->codigo); ?> - <?php echo e($unidad->nombre); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
						</div>
						<div class="row form-action">
							<div class="col-md-6">
								<a href="<?php echo e(route('login')); ?>" id="show-signin" class="btn btn-danger btn-link w-100 fw-bold">Cancelar</a>
							</div>
							<div class="col-md-6">
								<button type="submit" class="btn btn-dark w-100 fw-bold">Enviar Datos</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<?php echo $__env->make('intranet.layouts.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<script>
		$('#unidad_id').select2();
		$(function(){
		$(".validar").keydown(function(event){
			//alert(event.keyCode);
			if((event.keyCode < 48 || event.keyCode > 57) && (event.keyCode < 96 || event.keyCode > 105) && event.keyCode !==190  && event.keyCode !==110 && event.keyCode !==8 && event.keyCode !==9  ){
				return false;
			}
		});
	});
	</script>
</body>
</html><?php /**PATH /var/www/html/intranet/resources/views/intranet/auth/register.blade.php ENDPATH**/ ?>