<div>
    <div class="row mb-2">
        <div class="col-md-4 mb-1 pr-0">
            <div class="form-group pt-0">
                <i class="fas fa-filter mr-2"></i><label for="">Tipo Documento</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="tipoFiltro" class="form-control tipo_contenido" id="tipo">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($tipos as $t)
                            <option value="{{ $t->id }}">{{ $t->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_tipo" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pl-0 pt-0 ">
                <i class="fas fa-filter mr-2"></i><label for="">Grupo</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="grupoFiltro" class="form-control grupo" id="grupo">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($grupos as $g)
                            <option value="{{ $g->id }}">{{ $g->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_grupo" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-1 pl-0 pr-0">
            <div class="form-group pl-0 pt-0">
                <i class="fas fa-filter mr-2"></i><label for="">Estado Documento</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoDocumentoFiltro" class="form-control estado_documento_id" id="estadoDocumento">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($estados as $e)
                            <option value="{{ $e->id }}">{{ $e->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_estado" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-md-6 mb-1 pr-0">
            <div class="form-group pl-0 pt-0">
                <i class="fas fa-filter mr-2"></i><label for="">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltro" class="form-control unidad_id" id="unidad">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($unidades as $unidad)
                            <option value="{{ $unidad->id }}">{{ $unidad->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-1 pl-0">
            <div class="form-group pl-0 pt-0">
                <i class="fas fa-search mr-2"></i><label for="">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="search" id="searchFilter" class="form-control" placeholder="Ingrese una palabra para la búsqueda....">
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <div class="text-center">
            <div wire:loading>
                Filtrando...
            </div>
        </div>
        <table class="table table-hover" >
            <thead>
                <tr>
                    <th class="text-center"></th>
                    <th class="text-center">Fecha</th>
                    <th class="text-center">Nro. Resolución</th>
                    <th class="text-center">Título</th>
                    <th class="text-center">Descripción</th>
                    <th class="text-center">Grupo</th>
                    <th class="text-center">Tipo Documento</th>
                    <th class="text-center">Estado Documento</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($documentos as $doc)
                <tr>
                    <td class="text-center col-1">
                        <a class="btn btn-link btn-danger pb-0 pt-0" href="{{ route('ver_adjuntos', $doc) }} " target="_blank" title="Ver documento" data-toggle="tooltip"><i class="fas fa-file-pdf"></i> Ver</a>
                    </td>
                    <td class="text-center">{{ date('d/m/Y',strtotime($doc->fecha)) }}</td>
                    <td class="text-center col-3">{{ $doc->nro_resolucion }} </td>
                    <td class="text-left col-4">{{ $doc->titulo }} </td>
                    <td class="text-left col-3">{{ $doc->descripcion }} </td>
                    <td class="text-center"><span class="badge badge-warning">{{ $doc->grupo->nombre }}</span> </td>
                    <td class="text-center"><span class="badge badge-default">{{ $doc->tipo->nombre }}</span></td>
                    <td class="text-center">
                        @switch($doc->estado_documento->nombre)
                            @case('VIGENTE')
                                <span class="badge badge-success">{{ $doc->estado_documento->nombre }}</span>
                                @break
                            @case('NO VIGENTE')
                                <span class="badge badge-danger">{{ $doc->estado_documento->nombre }}</span>
                                @break
                            @default
                                {{ $doc->estado_documento->nombre }}
                        @endswitch
                        {{-- @if($doc->estado_documento->nombre == 'VIGENTE') <span class="badge badge-success">{{ $doc->estado_documento->nombre }}</span> @else <span class="badge badge-danger">{{ $doc->estado_documento->nombre }}</span> @endif  --}}
                    </td>
                </tr>
                @empty
                <div class="bg-warning-light text-center">
                    <h3 class="pt-2 pb-2">No se encontraron resultados de acuerdo al filtro ingresado...</h3>
                </div>
                @endforelse
            </tbody>
        </table>
        <div class="d-flex justify-content-end">{{ $documentos->links() }}</div>
    </div>
</div>
@section('scripts')
<script>
    $(document).ready(function () {
        window.initSelectCompanyDrop=()=>{
            $('.unidad_id').select2();
            $('.grupo').select2();
            $('.tipo_contenido').select2();
        }
        initSelectCompanyDrop();
        $('.tipo_contenido').on('change', function () {
                @this.set('tipoFiltro', $(this).val());
            });
        $('.grupo').on('change', function () {
                @this.set('grupoFiltro', $(this).val());
            });
        $('.unidad_id').on('change', function () {
                @this.set('unidadFiltro', $(this).val());
            });
        
        window.livewire.on('select2',()=>{
            initSelectCompanyDrop();
        });
    });
</script>
@endsection
