<p>Debe rellenar todos los campos marcados con <strong class="text-danger">(*)</strong>.
    Al momento de registrar/editar un usuario, debe asignarle un rol, para que pueda solo ver y administrar la información que corresponda</p>
@if ($errors->any())
    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
    <ul class="list-ticked mensaje-error">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row mb-1 {{ $errors->has('empleado_id') ? 'has-error' : '' }}">
    <label for="empleado_id" class="col-md-4 col-form-label text-right">Funcionario </label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="empleado_id"  class="form-control form-control {{ $errors->has('empleado_id') ? ' form-control-danger' : '' }}" id="empleado_id"  data-ruta="{{ route('admin.empleados.search') }}">
            <option value="">--BUSQUE Y SELECCIONE--</option>
            @foreach($empleados as $empleado)
                <option value="{{$empleado->ci}}" {{ old('empleado_id', $user->empleado_ci)== $empleado->ci ? 'selected' : '' }}>{{ $empleado->login }} - {{ $empleado->nombre }} - {{ $empleado->cargo }} - {{ $empleado->unidad }} - {{ $empleado->area }} - {{ $empleado->entidad }} - {{ $empleado->ci }}</option>
            @endforeach
        </select>
    </div>
</div>
@if(auth()->user()->rol[0]->id < 5 || auth()->user()->rol[0]->id == 7)
<div class="row mb-1 {{ $errors->has('role_id') ? 'has-error' : '' }}">
    <label for="role_id" class="col-md-4 col-form-label text-right">Rol <span class="text-danger">(*)</span></label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="role_id"  class="form-control form-control {{ $errors->has('role_id') ? ' form-control-danger' : '' }}" id="role_id" onchange="changeRol(this)">
            <option value="">--SELECCIONE--</option>
            @foreach($roles as $rol)
                @if($rol->id >=auth()->user()->rol[0]->id && $rol->id != 7)
                    <option value="{{$rol->id}}" {{ old('role_id',count($user->rol)>0 ? $user->rol[0]->id :'')== $rol->id ? 'selected' : '' }}>{{$rol->name}} <em>({{$rol->descripcion}})</em></option>
                @else
                    @if($rol->id > 2)
                        <option value="{{$rol->id}}" {{ old('role_id',count($user->rol)>0 ? $user->rol[0]->id :'')== $rol->id ? 'selected' : '' }}>{{$rol->name}} <em>({{$rol->descripcion}})</em></option>
                    @endif
                @endif
            @endforeach
        </select>
    </div>
</div>
@endif
<div class="row mb-1 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
    <label for="unidad_id" class="col-md-4 col-form-label text-right">Unidad <span class="text-danger">(*)</span></label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="unidad_id"  class="form-control form-control {{ $errors->has('unidad_id') ? ' form-control-danger' : '' }}" id="unidad" >
            <option value="">--BUSQUE Y SELECCIONE--</option>
            @foreach($unidades as $unidad)
                <option value="{{$unidad->id}}" {{ old('unidad_id', $user->unidad_id)== $unidad->id ? 'selected' : '' }}>{{ $unidad->nombre }} </option>
            @endforeach
        </select>
    </div>
</div>
<div class="row mb-1 {{ $errors->has('name') ? 'has-error' : '' }}">
    <label for="name" class="col-md-4 col-form-label text-right">Nombre Completo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="name" type="text" class="form-control {{ $errors->has('name') ? ' form-control-danger' : '' }}" name="name" value="{{ old('name',$user->name) }}"  autofocus onkeyup="javascript:this.value=this.value.toUpperCase();" >
    </div>
</div>
<div class="row mb-1 {{ $errors->has('empleado_ci') ? 'has-error' : '' }}">
    <label for="empleado_ci" class="col-md-4 col-form-label text-right">CI: <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="empleado_ci" type="text" class="form-control {{ $errors->has('empleado_ci') ? ' form-control-danger' : '' }}" name="empleado_ci" value="{{ old('name',$user->empleado_ci) }}">
    </div>
</div>

<div class="row mb-1 {{ $errors->has('entidad') ? 'has-error' : '' }}">
    <label for="entidad" class="col-md-4 col-form-label text-right ">Entidad RRHH</label>
    <div class="col-md-6">
        <input id="entidad" type="text" class="form-control{{ $errors->has('entidad') ? ' form-control-danger' : '' }}" name="entidad" value="{{ old('entidad',$user->entidad) }}">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('cargo') ? 'has-error' : '' }}">
    <label for="cargo" class="col-md-4 col-form-label text-right ">Cargo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="cargo" type="text" class="form-control{{ $errors->has('cargo') ? ' form-control-danger' : '' }}" name="cargo" value="{{ old('cargo',$user->cargo) }}">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('area_rrhh') ? 'has-error' : '' }}">
    <label for="area_rrhh" class="col-md-4 col-form-label text-right ">area_rrhh</label>
    <div class="col-md-6">
        <input id="area_rrhh" type="text" class="form-control{{ $errors->has('area_rrhh') ? ' form-control-danger' : '' }}" name="area_rrhh" value="{{ old('area_rrhh',$user->area_rrhh) }}">
        <input id="area_rrhh_id" type="hidden" name="area_rrhh_id" value="{{ old('area_rrhh_id',$user->area_rrhh_id) }}">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('unidad_rrhh') ? 'has-error' : '' }}">
    <label for="unidad_rrhh" class="col-md-4 col-form-label text-right ">unidad_rrhh</label>
    <div class="col-md-6">
        <input id="unidad_rrhh" type="text" class="form-control{{ $errors->has('unidad_rrhh') ? ' form-control-danger' : '' }}" name="unidad_rrhh" value="{{ old('unidad_rrhh',$user->unidad_rrhh) }}">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('username') ? 'has-error' : '' }}">
    <label for="username" class="col-md-4 col-form-label text-right ">Nombre de usuario para acceder <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="username" type="text" class="form-control{{ $errors->has('username') ? ' form-control-danger' : '' }}" name="username" value="{{ old('username',$user->username) }}">
    </div>
</div>
<div class="row mb-1 {{ $errors->has('email') ? 'has-error' : '' }}">
    <label for="email" class="col-md-4 col-form-label text-right ">Correo Institucional <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' form-control-danger' : '' }}" name="email" value="{{ old('email',$user->email) }}">
    </div>
</div>
<div class="row mb-0 {{ $errors->has('password') ? 'has-error' : '' }}">
    <label for="password" class="col-md-4 col-form-label text-right ">{{ $texto_pass }} @if($tipo==1) <span class="text-danger">(*)</span> @endif</label>

    <div class="col-md-6">
        <input id="password" type="password" class="form-control @error('password') error @enderror" name="password" autocomplete="new-password">
    </div>
</div>
@if($tipo==1)
    <div class="row mt-1">
        <label for="password-confirm" class="col-md-4 col-form-label text-right ">{{ __('Confirm Password') }} <span class="text-danger">(*)</span></label>
        <div class="col-md-6">
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" >
        </div>
    </div>
@endif
<div class="text-center mt-3">
    <button type="submit" class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('users.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>