@extends('admin.layouts.app_admin')
@section('titulo','Editar Unidad')

@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Editar Unidad</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="{{ route('users.index') }}">Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Editar Unidad</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Datos de la Unidad</h4>
                </div>
                <div class="card-body">
                <h4 class="h4"></h4>
                {!! Form::model($unidad,['route'=>['unidades.update',$unidad->id],'method'=>'PUT','class'=>'needs-validation']) !!}
                    @include('admin.unidades._form',['texto' => 'Actualizar','color'=>'success'])
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $("#area_id").select2({
        placeholder: '--BUSQUE Y SELECCIONE--',
        width: 'resolve'
    }).on('select2-open', function () {
        // Adding Custom Scrollbar
        $(this).data('select2').results.addClass('overflow-hidden').perfectScrollbar();
    });
</script>
@endsection