@extends('admin.layouts.app_admin')
@section('titulo','Nueva Unidad')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Nuevo Unidad</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Nueva Unidad</a></li>
        </ul>
    </div>
    <div class="row mt--2">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Datos de la Unidad</h4>
                </div>
                <div class="card-body">
                    {!! Form::open(['route'=>'unidades.store','class'=>'form-horizontal']) !!}
                    @include('admin.unidades._form',['texto' => 'Registrar','color'=>'primary'])
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script>
    $("#area_id").select2({
        placeholder: '--BUSQUE Y SELECCIONE--',
        width: 'resolve'
    }).on('select2-open', function () {
        // Adding Custom Scrollbar
        $(this).data('select2').results.addClass('overflow-hidden').perfectScrollbar();
    });
</script>
@endsection