
<p>Debe rellenar todos los campos.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row">
    <div class="col-md-2">
        <div class="form-group pb-0 {{ $errors->has('fecha') ? 'has-error' : '' }}">
            <label for="">Fecha Publicación <span class="text-danger">(*)</span></label>
            <input type="date" name="fecha" id="fecha" class="form-control" value="{{ old('fecha',$socialComunidad->fecha == null ? date('Y-m-d') : $socialComunidad->fecha) }}">
        </div>
    </div>
    @if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3)
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Unidad Institucional <span class="text-danger">(*)</span></label>
            <select name="unidad_id" id="unidad_id" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$socialComunidad->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible', isset($socialComunidad) && $socialComunidad->exists ? $socialComunidad->visible : '')==1 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible', isset($socialComunidad) && $socialComunidad->exists ? $socialComunidad->visible : '')==0 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Título <span class="text-danger">(*)</span></label>
            <input type="text" name="titulo" id="titulo" class="form-control" value="{{ old('titulo',$socialComunidad->titulo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <input type="text" name="descripcion" id="descripcion" class="form-control" value="{{ old('descripcion',$socialComunidad->descripcion) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 mb-0 {{ $errors->has('adjunto_tipo') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Tipo de Adjunto<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="adjunto_tipo"  value="imagen" {{ old('adjunto_tipo', isset($contenidoPagina) && $contenidoPagina->exists ? $contenidoPagina->adjunto_tipo : '')=='imagen' ? 'checked' : '' }}>
                    <span class="form-radio-sign">Imagen</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="adjunto_tipo" value="video" {{ old('adjunto_tipo', isset($contenidoPagina) && $contenidoPagina->exists ? $contenidoPagina->adjunto_tipo : '')=='video' ? 'checked' : '' }}>
                    <span class="form-radio-sign">Video</span>
                </label>
            </div>
        </div>
        <div class="form-group pb-0 {{ $errors->has('adjunto') ? 'has-error' : '' }}">
            <label for="file" >Adjunto  <span class="text-danger">(*)</span></label>
            <input type="file" name="adjunto" id="adjunto" class="form-control" accept="video/*">
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            @if($socialComunidad->adjunto!=null)
            <label for="file" class="mt-2" >Documento Adjunto: </label><a href="{{ asset('adjuntos/'.$socialComunidad->adjunto) }}" target="_blank" class="btn btn-primary btn-link"><span class="btn-label">
                <i class="fa fa-link"></i>
            </span>{{ $socialComunidad->adjunto }}</a>
            @endif
        </div>
        <div id="preview"></div>
    </div>
</div>
<div class="form-check">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$socialComunidad->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign">Marcar si quiere publicar el contenido</span>
    </label>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('sociales.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>