@extends('admin.layouts.app_admin')
@section('titulo','Sitios Web')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Ver Registrados</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Sitios Web</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Opciones que se muestran al ingresar al intranet</h4>
                    @can('sitios_web.create')
                      <a href="{{ route('sitios_web.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover table-sm" id="datos">
                    <thead>
                      <th class="text-center">Nombre</th>
                      <th class="text-center">URL</th>
                      <th class="text-center">Orden o Posición</th>
                      <th class="text-center">Acciones</th>
                    </thead>
                    <tbody>
                      @foreach($sitios as $menu)
                        <tr>
                          <td class="text-left">{{ $menu->name }}</td>
                          <td class="text-left"> {{ $menu->url }}</td>
                          <td class="text-center">{{ $menu->order }}</td>
                          <td class="text-center">
                            <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown">
                                OPCIONES
                            </button>
                            <ul class="dropdown-menu" role="menu">
                                <li>
                                    @can('sitios_web.edit')
                                        <a class="dropdown-item" href="{{ route('sitios_web.edit', $menu) }}" href="#">Modificar Datos</a>
                                    @endcan
                                    @can('sitios_web.destroy')
                                        <form action="{{ route('sitios_web.destroy', $menu) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea eliminar el SITIO WEB?');">Eliminar</button>
                                        </form>
                                    @endcan
                                </li>
                            </ul>
                          </td>
                        </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection