@extends('admin.layouts.app_admin')
@section('titulo','Editar Item de Menú')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Editar Opción</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Menú de Opciones</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Ver Menú</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Editar Opción</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($sitioWeb,['route'=>['sitios_web.update',$sitioWeb->id],'method'=>'PUT','id'=>'form-menu']) !!}
                        @include('admin.sitios_web._form',['texto' => 'Actualizar','color'=>'success'])
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    document.getElementById('form-menu').addEventListener('submit', function(e) {
        e.preventDefault(); // evita el envío inmediato del formulario
    
        const name = document.getElementById('name').value.trim();
        const url = document.getElementById('url').value.trim();
    
        if (!name || !url) {
            Swal.fire('Campos obligatorios', 'Debe completar el nombre y la URL', 'warning');
            return;
        }
    
        Swal.fire({
            title: '¿Desea guardar los cambios?',
            html: `<strong>Nombre:</strong> ${name}<br><strong>URL:</strong> ${url}`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sí, guardar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                e.target.submit(); // si se confirma, envía el formulario
            }
        });
    });
    </script>
@endsection