@extends('admin.layouts.app_admin')
@section('titulo','Nuevo Rol')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Configuración Acceso</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Roles</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Nuevo Rol</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Nuevo Rol</div>
                </div>
                <div class="card-body">
                    {!! Form::open(['route'=>'roles.store','class'=>'forms-sample']) !!}
                    @include('admin.roles._form')
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $(document).ready(function() {
        $('.marcar-todos').click(function() {
            var grupoId = $(this).data('grupo');
            var checked = $(this).prop('checked');
            $('input[type="checkbox"][data-grupo="' + grupoId + '"]').prop('checked', checked);
                // Detectar elementos marcados y mostrar el acordeón
                updateSelectedCount(grupoId);
        });
    });
    function updateSelectedCount(grupoId) {
        var checkedCount = $('input[type="checkbox" ][data-grupo="' + grupoId + '"]:checked').length;
        var totalCount = $('input[type="checkbox"][data-grupo="' + grupoId + '"]').length;
        totalCount=totalCount-1;        
        $('#contador-' + grupoId).html(checkedCount + ' de ' + totalCount  + ' seleccionados');
    }
    $('input[type="checkbox"]').change(function() {
        var grupoId = $(this).data('grupo');
        updateSelectedCount(grupoId);
    });
     // Inicializar contadores
     $('[data-grupo]').each(function() {
        var grupoId = $(this).data('grupo');
        updateSelectedCount(grupoId);
    });
  </script>
@endSection







