@extends('admin.layouts.app_admin')
@section('titulo','Registro de Eventos')
@section('content')


<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Eventos</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Eventos</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="#">Ver Registrados</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <div class="card-title">Eventos Registrados</div>
                      <div class="card-category">Listado de eventos registrados para cada unidad.</div>
                    </div>
                    @can('eventos.create')
                      <a href="{{ route('eventos.create') }}" class="btn btn-primary btn-rounded">Agregar Nuevo</a>
                    @endcan
                  </div>
              </div>
              <div class="card-body">
              @livewire('admin.evento-component')
              </div>
          </div>
      </div>
  </div>
</div>

@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection