
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row">
    <div class="col-md-4">
        <div class="form-group {{ $errors->has('fecha_inicio') ? 'has-error' : '' }}">
            <label for="fecha_inicio">Fecha Inicio <span class="text-danger">(*)</span></label>
            <input type="datetime-local" name="fecha_inicio" id="fecha_inicio" class="form-control" value="{{ old('fecha_inicio',$evento->fecha_inicio == null ? date('Y-m-d') : $evento->fecha_inicio) }}">
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group {{ $errors->has('fecha_fin') ? 'has-error' : '' }}">
            <label for="fecha_fin">Fecha Finalización <span class="text-danger">(*)</span></label>
            <input type="datetime-local" name="fecha_fin" id="fecha_fin" class="form-control" value="{{ old('fecha_fin',$evento->fecha_fin == null ? date('Y-m-d') : $evento->fecha_fin) }}">
        </div>
    </div>
    @if(auth()->user()->unidad_id==null || auth()->user()->rol[0]->id==3)
    <div class="col-md-4">
        <div class="form-group {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Unidad Institucional <span class="text-danger">(*)</span></label>
            <select name="unidad_id" id="unidad_id" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$evento->unidad_id==null ? Auth::user()->unidad_id : $evento->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif
   
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible',$evento->visible != null ? $evento->visible : '') == 1 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible',$evento->visible != null ? $evento->visible : '') == 0 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Título <span class="text-danger">(*)</span></label>
            <input type="text" name="titulo" id="titulo" class="form-control" value="{{ old('titulo',$evento->titulo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="form-group {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <textarea name="descripcion" id="descripcion" cols="30" rows="2" class="form-control" onkeyup="javascript:this.value=this.value.toUpperCase();">{{ old('descripcion',$evento->descripcion) }}</textarea>
        </div>
    </div>
</div>
<div class="form-check">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$evento->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign">Marcar si quiere publicar el evento</span>
    </label>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('eventos.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>