<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif

<div class="row mb-2 {{ $errors->has('unidad_id') ? 'has-error' : '' }}"" >
    <label for="unidad_id" class="col-md-4 col-form-label text-right">Unidad <span class="text-danger">(*)</span></label>
    <div class="col-md-8">
        <select name="unidad_id" id="unidad_id" class="form-control">
            <option value="">-- BUSQUE Y SELECCIONE --</option>
            @foreach($unidades as $unidad)
                <option value="{{$unidad->id}}" {{ old('unidad_id', $empleado->unidad_id)== $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }} </option>
            @endforeach
        </select>
    </div>
</div>
<div class="row mb-2 {{ $errors->has('nombre') ? 'has-error' : '' }}">
    <label for="nombre" class="col-md-4 col-form-label text-right">Nombre Completo <span class="text-danger">(*)</span></label>
    <div class="col-md-8">
        <input type="text" class="form-control" id="nombre" name="nombre" value="{{  old('nombre',$empleado->nombre) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>
<div class="row mb-2 {{ $errors->has('cargo') ? 'has-error' : '' }}">
    <label for="cargo" class="col-md-4 col-form-label text-right">Cargo <span class="text-danger">(*)</span></label>
    <div class="col-md-8">
        <input type="text" class="form-control" id="cargo" name="cargo" value="{{  old('cargo',$empleado->cargo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>
<div class="row mb-2 {{ $errors->has('fecha_nacimiento') ? 'has-error' : '' }}">
    <label for="fecha_nacimiento" class="col-md-4 col-form-label text-right">Fecha Nacimiento <span class="text-danger">(*)</span></label>
    <div class="col-md-4 ">
        <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" value="{{  old('fecha_nacimiento',$empleado->fecha_nacimiento) }}">
    </div>
</div>
<div class="row mb-2 {{ $errors->has('genero') ? 'has-error' : '' }}">
    <label for="genero" class="col-md-4 col-form-label text-right">Genero <span class="text-danger">(*)</span></label>
    <div class="col-md-4 ">
        <select name="genero" id="genero" class="form-control">
            <option value="">-- SELECCIONE --</option>
            <option value="MASCULINO" {{ old('genero', $empleado->genero)== 'MASCULINO' ? 'selected' : '' }}>MASCULINO</option>
            <option value="FEMENINO" {{ old('genero', $empleado->genero)== 'FEMENINO' ? 'selected' : '' }}>FEMENINO</option>
        </select>
    </div>
</div>
<div class="text-center mt-3">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('empleados.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>