
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<input type="hidden" name="menu_id" id="menu_id" value="{{ $seccion }}">
<div class="row">
    <div class="col-lg-2 col-md-4 pr-0">
        <div class="form-group pb-0 {{ $errors->has('fecha') ? 'has-error' : '' }}">
            <label for="">Fecha Publicación <span class="text-danger">(*)</span></label>
            <input type="date" name="fecha" id="fecha" class="form-control" value="{{ old('fecha',$documentoInterno->fecha == null ? date('Y-m-d') : $documentoInterno->fecha) }}">
        </div>
    </div>

    <div class="col-lg-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '3' : '4' }} col-md-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '4' : '6' }} pr-0">
        <div class="form-group pb-0 {{ $errors->has('contenido_tipo_id') ? 'has-error' : '' }}">
            <div class="d-flex align-items-center justify-content-between">
                <label for="">Tipo Documento <span class="text-danger">(*)</span></label>
                <span  data-toggle="modal" data-target="#newTipoContenido">
                    <button type="button" class="btn btn-primary btn-icon btn-sm" data-toggle="tooltip" title="Agregar un Nuevo Tipo de Contenido" ><i class="fas fa-plus"></i></button>
                </span>
            </div>
            <select name="contenido_tipo_id" id="tipo" class="form-control">
                <option value="">-- BUSQUE Y SELECCIONE --</option>
                @foreach ($tipos as $t)
                    <option value="{{ $t->id }}" {{ old('contenido_tipo_id',$documentoInterno->contenido_tipo_id) == $t->id ? 'selected' : '' }}>{{ $t->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-lg-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '3' : '4' }} col-md-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '4' : '6' }} pr-0">
        <div class="form-group pb-0 {{ $errors->has('grupo_id') ? 'has-error' : '' }}">
            <div class="d-flex align-items-center justify-content-between">
                <label for="">Grupo <span class="text-danger">(*)</span></label>
                <span data-toggle="modal" data-target="#newGrupo"><button type="button" class="btn btn-success btn-icon btn-sm"  data-toggle="tooltip" title="Agregar un Nuevo Grupo" ><i class="fas fa-plus"></i></button></span>
            </div>
            <select name="grupo_id" id="grupo_id" class="form-control select2" >
                <option value="">-- BUSQUE Y SELECCIONE --</option>
                @foreach ($grupos as $g)
                    <option value="{{ $g->id }}" {{ old('grupo_id',$documentoInterno->grupo_id) == $g->id ? 'selected' : '' }}>{{ $g->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3)
    <div class="col-lg-4 col-md-4">
        <div class="form-group pb-0 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Unidad Institucional <span class="text-danger">(*)</span></label>
            <select name="unidad_id" id="unidad_id" class="form-control select2" >
                <option value="">-- BUSQUE Y SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$documentoInterno->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif

    <div class="col-lg-4 col-md-6 pr-0">
        <div class="form-group pb-0 {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible', isset($documentoInterno) && $documentoInterno->exists ? $documentoInterno->visible : '')==1 ? 'checked' : '' }}>
                    <span class="form-radio-sign" style="font-weight: 400;">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible', isset($documentoInterno) && $documentoInterno->exists ? $documentoInterno->visible : '')== false ? 'checked' : '' }}>
                    <span class="form-radio-sign" style="font-weight: 400;">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-4 pr-0">
        <div class="form-group pb-0 {{ $errors->has('nro_resolucion') ? 'has-error' : '' }}">
            <label for="">Número de Resolución <span class="text-danger">(*)</span></label>
            <input type="text" name="nro_resolucion" id="nro_resolucion" class="form-control" value="{{ old('nro_resolucion',$documentoInterno->nro_resolucion) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Nombre / Título <span class="text-danger">(*)</span></label>
            <textarea name="titulo" id="titulo" cols="30" rows="2" class="form-control" onkeyup="javascript:this.value=this.value.toUpperCase();">{{ old('titulo',$documentoInterno->titulo) }}</textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <textarea name="descripcion" id="descripcion" cols="30" rows="5" onkeyup="javascript:this.value=this.value.toUpperCase();" class="form-control">{{ old('descripcion',$documentoInterno->descripcion) }}</textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('adjunto') ? 'has-error' : '' }}">
            <label for="file" >Adjunto  <span class="text-danger">(*)</span></label>
            <input type="file" name="adjunto" id="adjunto" class="form-control" accept=".pdf,.doc,.docx">
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            @if($documentoInterno->adjunto!=null)
            <label for="file" class="mt-2" >Documento Adjunto: </label><a href="{{ route('ver_adjuntos',$documentoInterno->id) }}" target="_blank" class="btn btn-primary btn-link"><span class="btn-label">
                <i class="fa fa-link"></i>
            </span>{{ $documentoInterno->adjunto_nombre_original }}</a>
            @endif
        </div>
        <div id="preview"></div>
    </div>
</div>
<div class="row">
    <div class="col-lg-4 col-md-4">
        <div class="form-group pb-0 {{ $errors->has('estado_documento_id') ? 'has-error' : '' }}">
            <label for="">Estado del DOCUMENTO <span class="text-danger">(*)</span></label>
            <select name="estado_documento_id" id="estado_documento_id" class="form-control select2" >
                <option value="">-- BUSQUE Y SELECCIONE --</option>
                @foreach ($estados as $estado)
                    <option value="{{ $estado->id }}" {{ old('estado_documento_id',$documentoInterno->estado_documento_id) == $estado->id ? 'selected' : '' }}>{{ $estado->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>
<div class="form-check mt-3">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$documentoInterno->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign" style="font-weight: 400;">Marcar si quiere publicar el contenido</span>
    </label>
</div>
<div class="text-center ">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('documentos_internos.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>