
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<input type="hidden" name="menu_id" id="menu_id" value="{{ $seccion }}">
<div class="row">
    <div class="col-md-2 pr-0">
        <div class="form-group pb-0 {{ $errors->has('fecha') ? 'has-error' : '' }}">
            <label for="">Fecha Publicación <span class="text-danger">(*)</span></label>
            <input type="date" name="fecha" id="fecha" class="form-control" value="{{ old('fecha',$documentoGeneral->fecha == null ? date('Y-m-d') : $documentoGeneral->fecha) }}">
        </div>
    </div>

    <div class="col-md-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '3' : '4' }} pr-0">
        <div class="form-group pb-0 {{ $errors->has('contenido_tipo_id') ? 'has-error' : '' }}">
            <div class="d-flex align-items-center justify-content-between">
                <label for="">Tipo Documento <span class="text-danger">(*)</span></label>
                <span  data-toggle="modal" data-target="#newTipoContenido">
                    <button type="button" class="btn btn-primary btn-icon btn-sm" data-toggle="tooltip" title="Agregar un Nuevo Tipo de Contenido" ><i class="fas fa-plus"></i></button>
                </span>
            </div>
            <select name="contenido_tipo_id" id="tipo" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($tipos as $t)
                    <option value="{{ $t->id }}" {{ old('contenido_tipo_id',$documentoGeneral->contenido_tipo_id) == $t->id ? 'selected' : '' }}>{{ $t->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>

    @if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3)
    <div class="col-md-{{ Auth::user()->unidad_id == null || auth()->user()->rol[0]->id==3 ? '3' : '4' }} pr-0 pr">
        <div class="form-group pb-0 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Unidad Institucional</label>
            <select name="unidad_id" id="unidad_id" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$documentoGeneral->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible', isset($documentoGeneral) && $documentoGeneral->exists ? $documentoGeneral->visible : '')==1 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible', isset($documentoGeneral) && $documentoGeneral->exists ? $documentoGeneral->visible : '')==0 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Nombre <span class="text-danger">(*)</span></label>
            <input type="text" name="titulo" id="titulo" class="form-control" value="{{ old('titulo',$documentoGeneral->titulo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <textarea name="descripcion" id="descripcion" cols="30" rows="5" onkeyup="javascript:this.value=this.value.toUpperCase();" class="form-control">{{ old('descripcion',$documentoGeneral->descripcion) }}</textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('adjunto') ? 'has-error' : '' }}">
            <label for="file" >Adjunto  <span class="text-danger">(*)</span></label>
            <input type="file" name="adjunto" id="adjunto" class="form-control" accept=".pdf,.doc,.docx,.xls,.xlsx">
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            @if($documentoGeneral->adjunto!=null)
            <label for="file" class="mt-2" >Documento Adjunto: </label><a href="{{ asset('adjuntos/'.$documentoGeneral->adjunto) }}" target="_blank" class="btn btn-primary btn-link"><span class="btn-label">
                <i class="fa fa-link"></i>
            </span>{{ $documentoGeneral->adjunto }}</a>
            @endif
        </div>
        <div id="preview"></div>
    </div>
</div>
<div class="form-check">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$documentoGeneral->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign">Marcar si quiere publicar el contenido</span>
    </label>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('documentos_generales.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>