@extends('admin.layouts.app_admin')
@section('titulo','Registrar Empleados')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Importar Registros</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Directorio Empleados</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Nuevo Registro</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Importar Registros</a></li>
        </ul>
    </div>
  <div class="row mt--2">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-body">
                <form action="{{ route('directorio_empleados.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <p class="mb-0">Para agregar registros desde archivo excel, puede cargar todos los empleados o solo algunos registros.</p>
                    <p>El archivo excel debe tener en la primera fila los campos: <strong>nombre_completo, cargo, oficina, interno</strong> haciendo referencia a los nombres de cada columna.</p>
                    <div class="form-group {{ $errors->has('adjunto') ? 'has-error' : '' }}">
                        <label>Tipo de importación <span class="text-danger">(*)</span></label><br/>
                        <label class="form-radio-label">
                            <input class="form-radio-input" type="radio" name="tipo_importacion" value="1" >
                            <span class="form-radio-sign">Reingresar Todos los registros</span>
                        </label>
                        <label class="form-radio-label ml-3">
                            <input class="form-radio-input" type="radio" name="tipo_importacion" value="0" >
                            <span class="form-radio-sign">Ingresar algunos registros</span>
                        </label>
                    </div>
                    <div class="form-group {{ $errors->has('adjunto') ? 'has-error' : '' }}">
                        <label for="file">Selecciona el archivo Excel <span class="text-danger">(*)</span></label>
                        <input type="file" class="form-control" id="file" name="file">
                    </div>
                    <div class="text-center"><button type="submit" class="btn btn-primary btn-rounded">Importar</button></div>
                </form>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
