@extends('admin.layouts.app_admin')
@section('titulo','Contenido para Páginas Intranet')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Contenidos de Páginas</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Contenidos</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Contenido registrado para cada opción del intranet</h4>
                    @can('contenidos.create')
                      <a href="{{ route('contenidos.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                <ul class="nav nav-pills nav-secondary  nav-pills-no-bd nav-pills-icons justify-content-center">
                  @foreach ($secciones as $key=>$seccion)
                  <li class="nav-item {{ $key == 0 ? 'active submenu' : '' }}" >
                    <a class="nav-link {{ $key == 0 ? 'active show' : '' }} " data-toggle="tab" href="#p{{ $seccion->id }}">{{ $seccion->name }}</a>
                  </li>
                  @endforeach
                </ul>
                <hr>
                <div class="tab-content">
                  @foreach ($secciones as $key2=>$seccion2)
                  <div id="p{{ $seccion2->id }}" class="tab-pane fade in {{ $key2 == 0 ? 'active show' : '' }}">
                    <h2 class="pb-2 text-center">{{ $seccion2->name }}</h2>
                    <div class="table-responsive">
                      <table class="table table-hover table-sm datatable">
                        <thead>
                          <th class="text-center">Fecha</th>
                          <th class="text-center">Título</th>
                          <th class="text-center">Tipo</th>
                          <th class="text-center">Unidad</th>
                          <th class="text-center">Visible</th>
                          <th class="text-center">Estado</th>
                          <th class="text-center">Acciones</th>
                        </thead>
                        <tbody>
                          @foreach($contenidos as $c)
                          @if($c->menu_item_id==$seccion2->id)
                            <tr>
                              <td class="text-left">{{date('d/m/Y',strtotime( $c->fecha)) }}</td>
                              <td class="text-left">{{ $c->titulo }} 
                                  @if($c->adjunto != null)
                                    @if($c->origen==1)
                                    <a href="{{ asset('adjuntos/'.date('Y',strtotime( $c->created_at)).'/'.date('m',strtotime( $c->created_at)).'/'.$c->adjunto) }}" target="_blank"> Ver adjunto</a>
                                    @else
                                    <a href="{{ asset('adjuntos/'.$c->adjunto) }}" target="_blank"> Ver adjunto</a>
                                    @endif
                                  @endif
                              </td>
                              <td class="text-center">{{ $c->tipo->nombre }}</td>
                              <td class="text-center">{{ $c->unidad != null ? $c->unidad->nombre : 'SEDEM' }}</td>
                              <td class="text-center">@if($c->visible == 1) <span class="badge badge-success">PARA TODOS</span> @else <span class="badge badge-secondary">SOLO UNIDAD</span> @endif</td>
                              <td class="text-center">@if($c->estado==0) <span class="badge badge-danger">NO PUBLICADO</span> @else <span class="badge badge-default">PUBLICADO</span> @endif</td>
                              <td class="text-center">
                                <div class="d-flex align-items-center justify-content-center">
                                  @can('contenidos.edit')
                                      <a href="{{ route('contenidos.edit', $c) }}"  title="Editar datos"><button class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit"></i></button></a>
                                      @if($c->estado==0)
                                      <a href="{{ route('contenidos.publicar', $c) }}"  title="Publicar contenido" onclick="return confirm('¿Está seguro que desea publicar el contenido?');"><button class="btn btn-info btn-icon btn-round"><i class="fas fa-cloud-upload-alt"></i></button></a>
                                      @endif
                                  @endcan
                                  @can('contenidos.destroy')
                                      <form action="{{ route('contenidos.destroy', $c) }}" method="POST" style="display: inline-block;">
                                      @csrf
                                      @method('DELETE')
                                      <button type="submit" class="btn btn-danger btn-icon btn-round" onclick="return confirm('¿Está seguro que desea eliminar el registro?');"><i class="fas fa-trash-alt"></i></button>
                                      </form>
                                  @endcan
                                </div>
                              </td>
                            </tr>
                            @endif
                          @endforeach
                        </tbody>
                      </table>
                    </div>
                  </div>
                  @endforeach
                </div>
                
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection