@if(auth()->user()->unidad_id != null)
<p>Puede registrar contenido para las paginas <strong>Noticias y Anuncios, Documentos internos, Documentos de interes, Capacitación, Social y Comunidad</strong> de su unidad o en el intranet central, debe seleccionar la sección y clasificar el contenido por el tipo.</p>
@else
<p>Puede registrar contenido para las paginas <strong>Noticias y Anuncios, Documentos internos, Documentos de interes, Capacitación, Social y Comunidad</strong>, solo debe indicar la sección y clasificar el contenido por el tipo, tambien puede agrupar la información por unidad, es decir, para que solo se visible para la unidad seleccionada, o para que se visualice en el intranet central a vista de todos los funcionarios.</p>
@endif
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('fecha') ? 'has-error' : '' }}">
            <label for="">Fecha Publicación <span class="text-danger">(*)</span></label>
            <input type="date" name="fecha" id="fecha" class="form-control" value="{{ old('fecha',$contenidoPagina->fecha == null ? date('Y-m-d') : $contenidoPagina->fecha) }}">
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('menu_item_id') ? 'has-error' : '' }}">
            <label for="">Sección <span class="text-danger">(*)</span></label>
            <select name="menu_item_id" id="menu_item_id" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($menuItems as $menuItem)
                    <option value="{{ $menuItem->id }}" {{ old('menu_item_id',$contenidoPagina->menu_item_id) == $menuItem->id ? 'selected' : '' }}>{{ $menuItem->name }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('contenido_tipo_id') ? 'has-error' : '' }}">
            <label for="">Tipo de Contenido <span class="text-danger">(*)</span></label>
            <select name="contenido_tipo_id" id="tipo" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($tipos as $t)
                    <option value="{{ $t->id }}" {{ old('contenido_tipo_id',$contenidoPagina->contenido_tipo_id) == $t->id ? 'selected' : '' }}>{{ $t->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>
<div class="row">
    @if(auth()->user()->unidad_id == null)
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Unidad Institucional</label>
            <select name="unidad_id" id="unidad_id" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$contenidoPagina->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible', isset($contenidoPagina) && $contenidoPagina->exists ? $contenidoPagina->visible : '')==1 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible', isset($contenidoPagina) && $contenidoPagina->exists ? $contenidoPagina->visible : '')==0 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Título <span class="text-danger">(*)</span></label>
            <input type="text" name="titulo" id="titulo" class="form-control" value="{{ old('titulo',$contenidoPagina->titulo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="form-group pb-0 {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <textarea name="descripcion" id="descripcion" cols="30" rows="10" class="form-control">{{ old('descripcion',$descripcion) }}</textarea>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pb-0 mb-0 {{ $errors->has('adjunto_tipo') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Tipo de Adjunto<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="adjunto_tipo"  value="imagen" {{ old('adjunto_tipo')=='imagen' ? 'checked' : '' }}>
                    <span class="form-radio-sign">Imagen</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="adjunto_tipo" value="video" {{ old('adjunto_tipo')=='video' ? 'checked' : '' }}>
                    <span class="form-radio-sign">Video</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="adjunto_tipo" value="archivo" {{ old('adjunto_tipo')=='archivo' ? 'checked' : '' }}>
                    <span class="form-radio-sign">Archivo</span>
                </label>
            </div>
        </div>
        <div class="form-group pb-0 {{ $errors->has('adjunto') ? 'has-error' : '' }}">
            <label for="file" >Adjunto  <span class="text-danger">(*)</span></label>
            <input type="file" name="adjunto" id="adjunto" class="form-control" >
            @if($contenidoPagina->adjunto!=null)
            <a href="{{ asset('adjuntos/'.$contenidoPagina->adjunto) }}" target="_blank" class="btn btn-info btn-sm">Ver Adjunto</a>
            @endif
        </div>
        <div id="preview">
            
        </div>
    </div>
</div>
<div class="form-check">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$contenidoPagina->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign">Marcar si quiere publicar el contenido</span>
    </label>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('contenidos.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>