@extends('admin.layouts.app_admin')
@section('titulo','Registro de comunicados')
@section('content')


<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Comunicados</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Comunicados</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="#">Ver Registrados</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <div class="card-title">Listado de comunicados Registrados</div>
                    </div>
                    @can('comunicados.create')
                      <a href="{{ route('comunicados.create') }}" class="btn btn-primary btn-rounded">Agregar Nuevo</a>
                    @endcan
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="datos">
                        <thead>
                            <tr>
                              <th class="text-center">Estado</th>
                                <th class="text-center">Fecha Desde</th>
                                <th class="text-center">Fecha Hasta</th>
                                <th class="text-center">Título</th>
                                <th class="text-center">Contenido</th>
                                <th class="text-center">URL</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($comunicados as $comunicado)
                                <tr>
                                  <td class="text-center">@if($comunicado->activo == true) <span class="badge badge-success">ACTIVO</span> @else <span class="badge badge-default">INACTIVO</span> @endif</td>
                                    <td class="text-center">{{ date('d/m/Y H:i', strtotime($comunicado->fecha_inicio)) }} </td>
                                    <td class="text-center">{{ date('d/m/Y H:i', strtotime($comunicado->fecha_fin)) }}</td>
                                    <td class="text-center">{{ $comunicado->titulo }}</td>
                                    <td class="text-center">{{ $comunicado->contenido }} </td>
                                    <td class="text-center">@if($comunicado->url != null) <a href="{{ route('ver_adjuntos',$comunicado->id) }}" title="Ver adjunto" data-toggle="tooltip" target="_blank"> <i class="fas fa-download mr-2"></i> Ver </a> @endif</td>
                                    <td class="d-flex justify-content-center align-items-center">
                                        @can('comunicados.edit')
                                          <a href="{{ route('comunicados.edit', $comunicado) }}" class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit pt-1 mt-2"></i></a>
                                        @endcan
                                        @can('comunicados.destroy')
                                          <form action="{{ route('comunicados.destroy', $comunicado) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-danger btn-icon btn-round" onclick="return confirm('¿Esta seguro que desea ELIMINAR el COMUNICADO?');"><i class="fas fa-trash-alt"></i></button>
                                          </form>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>

@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection