@extends('admin.layouts.app_admin')
@section('titulo','Clasificadores - Grupos')
@section('content')
    
<!--img-fondo-admin-->
<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Grupo</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Clasificadores</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Grupos</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="card-title">Tipos de grupos registrados</div>
                            <div class="card-category">El grupo permite clasificar los tipos de contenidos.</div>
                        </div>
                        @can('grupos.create')
                          <a href="javascript:void(0)" class="btn btn-primary btn-round" data-toggle="tooltip" title="Agregar un nuevo grupo" onclick="create();">Agregar Nuevo</a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-sm" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">Nombre del grupo</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.clasificadores.grupo._crud')
</div>
 @endsection
 @section('scripts')
 <script>
    $('.tipoFiltro').select2();
    var e = @json(auth()->user()->can('grupos.edit'));
    var d= @json(auth()->user()->can('grupos.destroy'));
</script>
 <script src="{{asset('assets/js/forms/clasificador/crudGrupo.js')}}"></script>
 @endsection