var adminUrl=url_global;
var _modal = $('#nuevaUnidad');
var area=$('#area_id').val();
var codigo_area=$('#area_codigo').val();

var btnSave = $('.btnSave');
var btnUpdate = $('.btnUpdate');
var csrf = $('input[name="_token"]').val();

var eliminar=$('#can_destroy').val();
var editar=$('#can_edit').val();

var cadena_eliminar='';
var cadena_editar='';

$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});
$(document).ready(function() {
    getRecords();

});

function getRecords() {
    $.getJSON(adminUrl + '/listar_unidades', {area_id:area}, function (json) {
        var data = json.map(function (fila) {
            if(eliminar==1){
                cadena_eliminar='<button type="button" class="btn btn-danger btn-icon btn-round btnDelete"  data-id="' + fila.id + '" title="Eliminar registro"><i class="fas fa-trash-alt"></i></button>';
            }
            if(editar==1){
                cadena_editar='<button type="button" class="btn btn-warning btn-icon btn-round btnEdit" data-id="' + fila.id + '" title="Modificar datos registro" ><i class="fas fa-edit"></i></button>';
            }
        return $.extend({ boton: cadena_editar+cadena_eliminar}, fila);
    });
    $('#datos').DataTable( {
            destroy:true,
            "language": {
                "processing": "Procesando...",
                "lengthMenu": 'Filtrar <select>'+
                    '<option value="10">10</option>'+
                    '<option value="20">20</option>'+
                    '<option value="30">30</option>'+
                    '<option value="40">40</option>'+
                    '<option value="50">50</option>'+
                    '<option value="-1">Todos</option>'+
                    '</select> Registros',
                "paginate": {
                    "previous": '<i class="fa fa-angle-left"></i>',
                    "next": '<i class="fa fa-angle-right"></i>'
                },
                "info": "Pagina _PAGE_ de _PAGES_",
                "search": "Busqueda Gral.:",
                "emptyTable": "No existen datos registrados.",
                "infoEmpty": "",
            },
            ordering: false,
            pageLength: -1,
            paging: true,
            searching: true,
            info: false,
            data: data,
            columns: [
                {  data: "codigo",class:'text-center' },
                {  data: "nombre",class:'text-left' },
                {  data: "nombre",class:'text-left' },
                {  data: "orden",class:'text-center' },
                {  data: "boton",class:'text-center' },
            ]
        } );
    });
};



function reset() 
{
    _modal.find('input').each(function () 
    {
        $(this).val(null)
    })
};

function getInputs() 
{
    var id = $('input[name="unidad_id"]').val();
    var nombre = $('#nombreUnidad').val();
    var codigo = $('#codigoUnidad').val();
    var orden = $('#ordenUnidad').val();
    return {id: id, nombre: nombre,codigo:codigo,area_id:area,orden:orden};
};

function create() 
{ 
    _modal.find('.modal-title').text('NUEVA UNIDAD');
    reset();
    _modal.modal('show')
    $('#codigoUnidad').val(codigo_area);
    btnSave.show()
    btnUpdate.hide()
};
_modal.on('shown.bs.modal', function () {
    $('#nombreUnidad').trigger('focus')
  })

$(document).on('submit', '#store', function(event) {
	event.preventDefault();
    var unidadId = $('input[name="unidad_id"]').val();
    //console.log(id);
    Swal.fire({
        target: document.getElementById('nuevaUnidad'),
        title: 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/unidades/store',
                data:  getInputs(),
                dataType: 'JSON',
                success: function ()
                { 
                    _modal.modal('hide');
                    
                    if(unidadId != ''){
                        Swal.fire({
                            title: "Actualizado!",
                            text: "Datos actualizados correctamente.",
                            icon: "success"
                          });
                    }
                    else{
                        Swal.fire({
                            title: "Registrado!",
                            text: "Unidad registrada correctamente.",
                            icon: "success"
                          });
                    }
                    getRecords();
                },
                error: function (data) {
                    var e=data.responseJSON;
                    Swal.fire({
                        title: "Error!",
                        text: "Hubo un error al procesar su petición, comuniquese con el administrador, Gracias !",
                        icon: "error"
                      });
                }
            })
          
        }
      });
    
});

$('table').on('click', '.btnEdit', function ()
{ 
    var id = $(this).data('id');
    var codigo = $(this).parent().parent().find('td').eq(0).text()
    var nombre = $(this).parent().parent().find('td').eq(1).text()
    var orden = $(this).parent().parent().find('td').eq(2).text()
    _modal.find('.modal-title').text('MODIFICAR UNIDAD')
    _modal.modal('show')
    $('input[name="unidad_id"]').val(id);
    $('#codigoUnidad').val(codigo);
    $('#nombreUnidad').val(nombre);
    $('#ordenUnidad').val(orden);
    
    btnSave.hide()
    btnUpdate.show()

});


$('table').on('click', '.btnDelete', function () 
{
    var id = $(this).data('id');
    Swal.fire({
        title: 'Desea eliminar la Unidad seleccionada?', // 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'DELETE',
                url: adminUrl + '/eliminar_unidad/'+id,
                dataType: 'JSON',
                success: function ()
                { 
                    getRecords();
                    Swal.fire({
                        title: "Eliminado!",
                        text: "El registro fue eliminado correctamente.",
                        icon: "success"
                    });
                    
                },
            })
          
        }
      });   
});
