$(document).ready(function() {

    $('#unidad_id').select2({
       width: 'resolve'
    });
    $('#tipo').select2({
        width: 'resolve'
    });
    $('#grupo_id').select2({
        width: 'resolve'
    });

    const fileInput = document.getElementById('adjunto');
    const preview = document.getElementById('preview');

    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (!file) return;

        const fileType = file.type;
        const validImageTypes = ['image/jpeg', 'image/png', 'image/gif'];
        const validVideoTypes = ['video/mp4', 'video/webm', 'video/ogg'];

        if (validImageTypes.includes(fileType)) {
            const img = document.createElement('img');
            img.src = URL.createObjectURL(file);
            preview.innerHTML = '';
            preview.appendChild(img);
        } else if (validVideoTypes.includes(fileType)) {
            const video = document.createElement('video');
            video.src = URL.createObjectURL(file);
            video.controls = true;
            preview.innerHTML = '';
            preview.appendChild(video);
        } else {
            preview.innerHTML = `
                <p>Archivo seleccionado: ${file.name}</p>
                <p>Tipo: ${fileType}</p>
                <p>Tamaño: ${(file.size / 1024 / 1024).toFixed(2)} MB</p>
            `;
        }
    });
    $('input[name="adjunto_tipo"]').on('change', function(e) {
        // seleccionamos el elemento clickeado
        self = $(this);
        // validamos que este checked

        if(self.is(':checked')){
            switch (self.val()) {
                case 'imagen':
                    $('#adjunto').attr('accept', 'image/*');
                    break;
                case 'video':
                    $('#adjunto').attr('accept', 'video/*');
                    break;
                case 'archivo':
                    $('#adjunto').attr('accept', '.pdf,.doc,.docx');
                    break;
                
            }
        }
    });
});

function readURL(input) {
    if (input.files && input.files[0]) { //Revisamos que el input tenga contenido
        var reader = new FileReader(); //Leemos el contenido

        reader.onload = function (e) { //Al cargar el contenido lo pasamos como atributo de la imagen de arriba
            $('#preview').attr('src', e.target.result);
        }
        reader.readAsDataURL(input.files[0]);
    }
}


