 
var adminUrl=url_global;
var _modal = $('#nuevoGrupo');
var btnSave = $('.btnSave');
var btnUpdate = $('.btnUpdate');
var csrf = $('input[name="_token"]').val();
var cadena_eliminar='';
var cadena_editar='';
var cadena='';

$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});

function getRecords() {
    $.getJSON(adminUrl + '/listar_grupos', function (json) {
        var data = json.map(function (fila) {
            if(d){
                cadena_eliminar='<button type="button" class="btn btn-danger btn-icon btn-round btnDelete"  data-id="' + fila.id + '" title="Eliminar registro"><i class="fas fa-trash-alt"></i></button>';
            }
            if(e){
                cadena_editar='<button type="button" class="btn btn-warning btn-icon btn-round btnEdit" data-id="' + fila.id + '" title="Modificar datos registro" ><i class="fas fa-edit"></i></button>';
            }
            cadena=cadena_editar+cadena_eliminar;
        return $.extend({ boton: cadena}, fila);
    });
    $('#datos').DataTable( {
            destroy:true,
            
            "language": {
                "processing": "Procesando...",
                "lengthMenu": 'Filtrar <select>'+
                    '<option value="10">10</option>'+
                    '<option value="20">20</option>'+
                    '<option value="30">30</option>'+
                    '<option value="40">40</option>'+
                    '<option value="50">50</option>'+
                    '<option value="-1">Todos</option>'+
                    '</select> Registros',
                "paginate": {
                    "previous": '<i class="fa fa-angle-left"></i>',
                    "next": '<i class="fa fa-angle-right"></i>'
                },
                "info": "Pagina _PAGE_ de _PAGES_",
                "search": "Busqueda Gral.:",
                "emptyTable": "No existen datos registrados.",
                "infoEmpty": "",
            },
            fixedHeader: true,
            orderCellsTop: true,
            data: data,
            columns: [
                {  data: "nombre" },
                {  data: "boton",class:'text-center' },
            ]
        } );
    });
};

getRecords();

function reset() 
{
    _modal.find('input').each(function () 
    {
        $(this).val(null)
    })
    
};


function getInputs() 
{
    var id_grupo = $('input[name="grupo_id"]').val();
    var nombre_grupo = $('input[name="nombre_grupo"]').val();
    var tipo='grupo';
    return {id: id_grupo, nombre: nombre_grupo,tipo:tipo};
};

_modal.on('shown.bs.modal', function () {
    $('#nombre_grupo').trigger('focus')
})

function create() 
{ 
    _modal.find('.modal-title').text('Nuevo Grupo');
    reset();
    _modal.modal('show')
    btnSave.show()
    btnUpdate.hide()
};


$(document).on('submit', '#storeGrupo', function(event) {
	event.preventDefault();
    var tipoID=$('input[name="grupo_id"]').val();
    Swal.fire({
        target: document.getElementById('nuevoGrupo'),
        title: 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/grupos/store',
                data:  getInputs(),
                dataType: 'JSON',
                success: function ()
                { 
                    reset(_modal);
                    _modal.modal('hide');
                    getRecords();
                    if(tipoID != ''){
                        Swal.fire({
                            title: "Actualizado!",
                            text: "Datos actualizados correctamente.",
                            icon: "success"
                          });
                    }
                    else{
                        Swal.fire({
                            title: "Registrado!",
                            text: "Grupo registrado correctamente.",
                            icon: "success"
                          });
                    }
                    $('#seccionNombre').removeClass('has-error');
                },
                error: function (data) {
                    var e=data.responseJSON;
                    var errores=e.errors
                    console.log(data);
                    var html='<ul class="list-ticked">';
                    Swal.fire({
                        title: "Error!",
                        text: "Debe verificar los datos de entrada!!",
                        icon: "error"
                    });
                    if(errores.nombre != undefined){
                        html+='<li class="text-danger">'+e.errors.nombre+'</li>';
                        $('#seccionNombre').addClass('has-error');
                    }else{
                        $('#seccionNombre').removeClass('has-error');
                    }
                    
                    html+='</ul>';
                    $('#errores').html(html);
                }
            })
          
        }
      });
    
});

$('table').on('click', '.btnEdit', function ()
{ 
    var id = $(this).data('id');
    var nombre = $(this).parent().parent().find('td').eq(0).text()
    _modal.find('.modal-title').text('MODIFICAR GRUPO');
    _modal.modal('show')
    $('input[name="grupo_id"]').val(id);
    $('#nombre_grupo').val(nombre);
    btnSave.hide()
    btnUpdate.show()

});


$('table').on('click', '.btnDelete', function () 
{
    var id = $(this).data('id');
    Swal.fire({
        title: 'Desea eliminar el Grupo?', // 'Desea continuar?',
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si, Eliminar!',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'DELETE',
                url: adminUrl + '/grupos/'+id,
                dataType: 'JSON',
                success: function ()
                { 
                    getRecords();
                    Swal.fire({
                        title: "Eliminado!",
                        text: "El GRUPO fue eliminado correctamente.",
                        icon: "success"
                    });
                    
                },
            })
          
        }
      });   
});

