<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('eventos', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->text('descripcion')->nullable();
            $table->datetime('fecha_inicio');
            $table->datetime('fecha_fin');
            $table->unsignedInteger('unidad_id');
            $table->string('importancia')->default(1)->comment('1 = Alta, 2 = Media, 3 = Baja');
            $table->boolean('visible')->default(1)->comment('1 = Visible para todos, 0 = Privado solo para la unidad asignada');
            $table->foreign('unidad_id')->references('id')->on('unidads');
            $table->boolean('estado')->default(0)->comment('1 = Publicado, 0 = No publicado');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('eventos');
    }
};
