<div wire:ignore.self>
    <div class="row">
    <div class="col-xl-12 col-xxl-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Historial de Asignaciones</h4>
            </div>
            <div class="card-body">
                 <div class="row mb-3">
                    <div class="col-md-6">
                        <select class="form-control select2" wire:model.live="contratoFiltro" id="select-contrato">
                            <option value="">Todos los Contratos</option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $contratos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contrato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($contrato->id); ?>"><?php echo e($contrato->codigo); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                    </div>
                    <div class="col-md-6">
                        <select class="form-control select2" wire:model.live="responsableFiltro" id="select-responsable">
                            <option value="">Todos los Responsables</option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $responsables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($resp->id); ?>"><?php echo e($resp->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                    </div>
                </div>
                 <div class="mb-2">
                    <!--[if BLOCK]><![endif]--><?php if($contratoFiltro): ?>
                        <span class="badge badge-info">
                            Contrato: <?php echo e($contratos->find($contratoFiltro)?->codigo); ?>

                            <a href="#" wire:click.prevent="$set('contratoFiltro', '')" class="text-white ml-1">✖</a>
                        </span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!--[if BLOCK]><![endif]--><?php if($responsableFiltro): ?>
                        <span class="badge badge-info">
                            Responsable: <?php echo e($responsables->find($responsableFiltro)?->name); ?>

                            <a href="#" wire:click.prevent="$set('resonsableFiltro', '')" class="text-white ml-1">✖</a>
                        </span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="table-responsive">
                    <table class="table table-hover" id="datos">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Contrato</th>
                                <th class="text-center">Responsable</th>
                                <th class="text-center">Observación</th>
                                <th class="text-center">Fecha de Asignación</th>
                                <th class="text-center">Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $asignaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asignacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center">
                                        <!--[if BLOCK]><![endif]--><?php if($asignacion->trashed()): ?>
                                            <button class="btn btn-sm btn-outline-primary btn-restaurar" data-id="<?php echo e($asignacion->id); ?>" title="Rehabilitar">
                                                <i class="fa fa-undo"></i>
                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn-sm btn-outline-danger btn-eliminar" data-id="<?php echo e($asignacion->id); ?>" title="Eliminar">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                    <td class="text-center"><?php echo e($asignacion->proceso->codigo); ?></td>
                                    <td class="text-center"><?php echo e($asignacion->responsable->name); ?></td>
                                    <td class="text-center"><?php echo e($asignacion->observacion); ?></td>
                                    <td class="text-center"><?php echo e($asignacion->created_at->format('d/m/Y H:i')); ?></td>
                                    <td class="text-center">
                                        <!--[if BLOCK]><![endif]--><?php if($asignacion->trashed()): ?>
                                            <span class="badge badge-danger">Eliminado</span>
                                        <?php else: ?>
                                            <span class="badge badge-success">Activo</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Sin asignaciones</td>
                                </tr>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                    <?php echo e($asignaciones->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
   
</div>

<?php $__env->startSection('scripts'); ?>



<script>
    $(document).on('click', '.btn-eliminar', function () {
        let id = $(this).data('id');

        Swal.fire({
            title: '¿Está seguro?',
            text: "Esta acción no se puede deshacer.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch('confirmar-eliminacion', { id: id });
            }
        });
    });
    $(document).on('click', '.btn-restaurar', function () {
        let id = $(this).data('id');

        Swal.fire({
            title: '¿Desea rehabilitar esta asignación?',
            text: "El registro volverá a estar activo.",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#198754',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, rehabilitar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch('confirmar-restauracion', { id: id });
            }
        });
    });

    // SweetAlert éxito tras restaurar
    Livewire.on('alerta-restaurado', () => {
        Swal.fire({
            title: '¡Rehabilitado!',
            text: 'La asignación fue rehabilitada correctamente.',
            icon: 'success',
            confirmButtonText: 'Aceptar'
        });
    });

    document.addEventListener('livewire:init', function () {
        $('#select-contrato').select2().on('change', function () {
            Livewire.dispatch('input', { name: 'contratoFiltro', value: $(this).val() });
        });
        $('#select-responsable').select2().on('change', function () {
            Livewire.dispatch('input', { name: 'responsableFiltro', value: $(this).val() });
        });
    });

    Livewire.on('alerta-eliminado', () => {
        Swal.fire({
            title: '¡Eliminado!',
            text: 'La asignación fue eliminada correctamente.',
            icon: 'success',
            confirmButtonText: 'Aceptar'
        });
    });
</script>
<?php $__env->stopSection(); ?><?php /**PATH C:\laragon\www\contrataciones\resources\views/livewire/asignaciones-component.blade.php ENDPATH**/ ?>