<div>
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Seguimientos registrados para los contratos</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <label>Contrato</label>
                            <select wire:model.live="contrato_id" class="form-control">
                                <option value="">Todos</option>
                                @foreach($contratos as $c)
                                    <option value="{{ $c->id }}">{{ $c->codigo }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Estado</label>
                            <select wire:model.live="estado_id" class="form-control">
                                <option value="">Todos</option>
                                @foreach($estados_seguimiento as $e)
                                    <option value="{{ $e->id }}">{{ $e->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Técnico</label>
                            <select wire:model.live="tecnico_id" class="form-control">
                                <option value="">Todos</option>
                                @foreach($tecnicos as $t)
                                    <option value="{{ $t->id }}">{{ $t->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Fecha</label>
                            <div class="d-flex">
                                <input wire:model.live="fecha_inicio" type="date" class="form-control me-2">
                                <input wire:model.live="fecha_fin" type="date" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="text-right mb-2">
                        @if($contrato_id || $estado_id || $tecnico_id || $fecha_inicio || $fecha_fin)
                            <strong class="text-primary">Filtros aplicados:</strong>
                        @endif
                        @if($contrato_id)
                            <span class="badge badge-outline-secondary ">
                                Contrato: {{ $contratos->find($contrato_id)?->nombre }}
                                <a href="#" wire:click.prevent="$set('contrato_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        @endif

                        @if($estado_id)
                            <span class="badge badge-outline-secondary ">
                                Estado: {{ $estados_seguimiento->find($estado_id)?->nombre }}
                                <a href="#" wire:click.prevent="$set('estado_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        @endif

                        @if($tecnico_id)
                            <span class="badge badge-outline-secondary ">
                                Técnico: {{ $tecnicos->find($tecnico_id)?->name }}
                                <a href="#" wire:click.prevent="$set('tecnico_id', '')" class="text-white ms-1">✖</a>
                            </span>
                        @endif

                        @if($fecha_inicio || $fecha_fin)
                            <span class="badge badge-outline-secondary ">
                                Fecha: {{ $fecha_inicio ? \Carbon\Carbon::parse($fecha_inicio)->format('d/m/Y') : '...' }} -
                                    {{ $fecha_fin ? \Carbon\Carbon::parse($fecha_fin)->format('d/m/Y') : '...' }}
                                <a href="#" wire:click.prevent="resetFechas" class="text-white ms-1">✖</a>
                            </span>
                        @endif

                        @if($contrato_id || $estado_id || $tecnico_id || $fecha_inicio || $fecha_fin)
                            <button wire:click="resetFiltros" class="btn btn-sm btn-outline-danger ms-2">Limpiar todos</button>
                        @endif
                    </div>

                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Fecha</th>
                                <th class="text-center">Estado</th>
                                <th class="text-center">Contrato</th>
                                <th class="text-center">Registrado por</th>
                                <th class="text-center">Observación</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($seguimientos as $s)
                                <tr>
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-outline-primary" wire:click="editar({{ $s->id }})"><i class="fa fa-edit"></i></button>
                                        <button class="btn btn-sm btn-outline-danger" onclick="eliminarConfirmado({{ $s->id }})"><i class="fa fa-trash"></i></button>
                                    </td>
                                    <td class="text-center">{{ date('d/m/Y', strtotime($s->fecha_seguimiento)) }}</td>
                                    <td class="text-center">{{ $s->estado->nombre ?? '' }}</td>
                                    <td class="text-center">{{ $s->contrato->codigo ?? 'N/A' }}</td>
                                    <td class="text-center">{{ $s->tecnico->name ?? '' }}</td>
                                    <td>{{ $s->observacion }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    {{ $seguimientos->links('pagination::bootstrap-4') }}

                    <livewire:contratos.seguimiento-modal />
                </div>
            </div>
        </div>
    </div>
    
</div>

@section('scripts')
<script>
    window.eliminarConfirmado = function (id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "Esto eliminará el seguimiento.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar'
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch('eliminar', { id });
            }
        });
    }

    Livewire.on('alerta', ({ text }) => {
        Swal.fire('Correcto', text, 'success');
    });

    Livewire.on('abrir-modal', () => {
        $('#modalSeguimiento').modal('show');
    });

    Livewire.on('cerrar-modal', () => {
        $('#modalSeguimiento').modal('hide');
    });
</script>
@endsection
