<div class="row">

    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="fecha_remision_juridica">Fecha de Remisión Jurídica</label>
            <input type="date" name="fecha_remision_juridica" id="fecha_remision_juridica" class="form-control @error('fecha_remision_juridica') error @enderror " value="{{ old('fecha_remision_juridica') ?? $contrato->fecha_remision_juridica ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="fecha_retorno_juridica">Fecha de Retorno Jurídica</label>
            <input type="date" name="fecha_retorno_juridica" id="fecha_retorno_juridica" class="form-control @error('fecha_retorno_juridica') error @enderror" value="{{ old('fecha_retorno_juridica') ?? $contrato->fecha_retorno_juridica ?? '' }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="tipo_contrato">Contrato - Orden de Compra / Servicio</label>
            <input type="text" name="tipo_contrato" id="tipo_contrato" class="form-control @error('tipo_contrato') error @enderror" value="{{ old('tipo_contrato') ?? $contrato->tipo_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="empresa_contratada_id">Empresa Contratada</label>
            <select name="empresa_contratada_id" id="empresa_contratada_id" class="form-control @error('empresa_contratada_id') error @enderror">
                <option value="">Seleccione</option>
                @foreach ($empresas as $empresa)
                    <option value="{{ $empresa->id }}" {{ $contrato->empresa_contratada_id == $empresa->id ? 'selected' : '' }}>{{ $empresa->nombre }}</option>
                @endforeach
            </select>
            <button type="button" class="btn btn-rounded btn-info" data-toggle="modal" data-target="#modal-empresa">Agregar Empresa</button>
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_contrato">Fecha de Contrato</label>
            <input type="date" name="fecha_contrato" id="fecha_contrato" class="form-control @error('fecha_contrato') error @enderror" value="{{ old('fecha_contrato') ?? $contrato->fecha_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="monto_contrato">Monto del Contrato</label>
            <input type="number" step="0.01" name="monto_contrato" id="monto_contrato" class="form-control @error('monto_contrato') error @enderror" value="{{ old('monto_contrato') ?? $contrato->monto_contrato }}">
        </div>
    </div>
    
</div>
<div class="row">
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="plazo_entrega">Plazo de Entrega (dias calendario)</label>
            <input type="text" name="plazo_entrega" id="plazo_entrega" class="form-control @error('plazo_entrega') error @enderror" value="{{ old('plazo_entrega') ?? $contrato->plazo_entrega }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="fecha_estimada_entrega">Fecha Estimada de Entrega</label>
            <input type="date" name="fecha_estimada_entrega" id="fecha_estimada_entrega" class="form-control @error('fecha_estimada_entrega') error @enderror" value="{{ old('fecha_estimada_entrega') ?? $contrato->fecha_estimada_entrega ?? '' }}">
        </div>
    </div>
</div>
<div class="text-center mt-3">
    <button type="submit" class="btn btn-rounded btn-{{ $color }}">{{ $texto }}</button>
    <a href="{{ route('contratos_juridicas.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>