<div class="row">
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_carta_adjudicacion">Fecha elaboración carta de Adjudicación</label>
            <input type="date" name="fecha_carta_adjudicacion" id="fecha_carta_adjudicacion" class="form-control @error('fecha_carta_adjudicacion') error @enderror" value="{{ old('fecha_carta_adjudicacion') ?? $contrato->fecha_carta_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 col-sm-12">
        <div class="form-group">
            <label for="fecha_notificacion_adjudicacion">Fecha notificación carta de Adjudicación</label>
            <input type="date" name="fecha_notificacion_adjudicacion" id="fecha_notificacion_adjudicacion" class="form-control @error('fecha_notificacion_adjudicacion') error @enderror" value="{{ old('fecha_notificacion_adjudicacion') ?? $contrato->fecha_notificacion_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 col-sm-12">
        <div class="form-group">
            <label for="monto_adjudicado">Monto Adjudicado</label>
            <input type="number" step="0.01" name="monto_adjudicado" id="monto_adjudicado" class="form-control @error('monto_adjudicado') error @enderror" value="{{ old('monto_adjudicado') ?? $contrato->monto_adjudicado }}">
        </div>
    </div>
    <div class="col-md-4 col-sm-12">
        <div class="form-group">
            <label for="empresa_adjudicada_id">Empresa Adjudicada</label>
            <select name="empresa_adjudicada_id" id="empresa_adjudicada_id" class="form-control @error('empresa_adjudicada_id') error @enderror">
                <option value="">Seleccione</option>
                @foreach ($empresas as $empresa)
                    <option value="{{ $empresa->id }}" {{ $contrato->empresa_adjudicada_id == $empresa->id ? 'selected' : '' }}>{{ $empresa->nombre }}</option>
                @endforeach
            </select>
            <button type="button" class="btn btn-rounded btn-info" data-toggle="modal" data-target="#modal-empresa">Agregar Empresa</button>
        </div>
    </div>
</div>
<div class="text-center mt-3">
    <button type="submit" class="btn btn-rounded btn-{{ $color }}">{{ $texto }}</button>
    <a href="{{ route('contratos_adjudicaciones.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>