<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // // // Usuarios
        Permission::create(['descripcion'=>'Ver todos los usuarios','name'=>'users.index','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Registar nuevos usuarios','name'=>'users.create','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Ver perfil de usuario','name'=>'users.show','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Edición de usuarios','name'=>'users.edit','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Eliminar usuario','name'=>'users.destroy','grupo'=>'01 - Administración']);

        // //Roles
        Permission::create(['descripcion'=>'Ver todos los roles','name'=>'roles.index','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Ver detalle de rol','name'=>'roles.show','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Creación de roles','name'=>'roles.create','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Edición de roles','name'=>'roles.edit','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Eliminar rol','name'=>'roles.destroy','grupo'=>'01 - Administración']);
        
        // //Permisos
        Permission::create(['descripcion'=>'Ver todos los permisos','name'=>'permisos.index','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Ver detalle de permiso','name'=>'permisos.show','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Creación de permisos','name'=>'permisos.create','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Edición de permisos','name'=>'permisos.edit','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Eliminar permiso','name'=>'permisos.destroy','grupo'=>'01 - Administración']);

        //parametros
        Permission::create(['descripcion'=>'Ver todos los parámetros','name'=>'parametros.index','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Registrar nuevos parámetros','name'=>'parametros.create','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Ver detalle de parámetro','name'=>'parametros.show','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Edición de parámetros','name'=>'parametros.edit','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Eliminar parámetro','name'=>'parametros.destroy','grupo'=>'02 - Parámetros']);

        //cONTRATOS
        Permission::create(['descripcion'=>'Ver todos los procesos de contratación','name'=>'procesos-contratacion.index','grupo'=>'03 - Contratos']);
        Permission::create(['descripcion'=>'Registrar nuevo proceso de contratación','name'=>'procesos-contratacion.create','grupo'=>'03 - Contratos']);
        Permission::create(['descripcion'=>'Ver detalle de proceso de contratación','name'=>'procesos-contratacion.show','grupo'=>'03 - Contratos']);
        Permission::create(['descripcion'=>'Edición de proceso de contratación','name'=>'procesos-contratacion.edit','grupo'=>'03 - Contratos']);
        Permission::create(['descripcion'=>'Eliminar proceso de contratación','name'=>'procesos-contratacion.destroy','grupo'=>'03 - Contratos']);

    }
}
