<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('procesos', function (Blueprint $table) {
            $table->id();
            $table->integer('nro')->nullable();
            $table->string('codigo')->unique(); 
            $table->string('nuri_informe')->nullable(); 
            $table->string('nuri_nota_autorizacion')->nullable(); 
            $table->string('codigo_c31')->nullable(); 
            $table->string('codigo_poa')->nullable(); 
            $table->string('codigo_pac')->nullable(); 
            $table->date('fecha_ingreso'); 
            $table->unsignedBigInteger('tipo_gasto_id')->nullable(); 
            $table->text('objeto_contratacion'); 
            // $table->string('unidad_solicitante'); 
            $table->unsignedBigInteger('normativa_id'); 
            $table->unsignedBigInteger('modalidad_id'); 
            $table->unsignedBigInteger('tipo_contratacion_id'); 
            $table->unsignedBigInteger('forma_adjudicacion_id'); 
            $table->unsignedBigInteger('tipo_formalizacion')->nullable(); 
            $table->string('unidad_solicitante')->nullable(); 
            $table->decimal('precio_referencial',10,2)->nullable(); 
            $table->string('fuente_organismo')->nullable(); 
            $table->string('numero_certificacion')->nullable(); 
            $table->date('fecha_autorizacion_inicio_proceso')->nullable();
            $table->string('nro_resolucion_autorizacion')->nullable();
            $table->date('fecha_resolucion_autorizacion')->nullable();
            $table->date('fecha_carta_adjudicacion')->nullable();
            $table->date('fecha_notificacion_adjudicacion')->nullable();
            $table->decimal('monto_adjudicado',10,2)->nullable();
            $table->unsignedBigInteger('empresa_adjudicada_id')->nullable();
            $table->date('fecha_remision_juridica')->nullable();
            $table->date('fecha_retorno_juridica')->nullable();
            $table->string('tipo_contrato')->nullable();
            $table->date('fecha_contrato')->nullable();
            $table->decimal('monto_contrato',10,2)->nullable();
            $table->unsignedBigInteger('empresa_contratada_id')->nullable();
            $table->string('plazo_entrega')->nullable();
            $table->date('fecha_estimada_entrega')->nullable();
            $table->string('cuce')->nullable();            
            $table->string('registro_contraloria')->nullable();
            $table->date('fecha_informe_conformidad')->nullable();
            $table->date('fecha_registro_sicoes')->nullable();
            $table->text('situacion_proceso',600)->nullable();
            $table->date('fecha_resimision_pago')->nullable();
            $table->string('recurrentes')->nullable();            
            $table->unsignedBigInteger('tipo_adjunto_id')->nullable();
            $table->unsignedBigInteger('entidad_id');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('tipo_gasto_id')->references('id')->on('parametros');
            $table->foreign('normativa_id')->references('id')->on('parametros');
            $table->foreign('modalidad_id')->references('id')->on('parametros');
            $table->foreign('empresa_adjudicada_id')->references('id')->on('empresas');
            $table->foreign('empresa_contratada_id')->references('id')->on('empresas');
            $table->foreign('tipo_adjunto_id')->references('id')->on('parametros');
            $table->foreign('entidad_id')->references('id')->on('parametros');
            $table->foreign('forma_adjudicacion_id')->references('id')->on('parametros');
            $table->foreign('tipo_contratacion_id')->references('id')->on('parametros');
            $table->foreign('tipo_formalizacion')->references('id')->on('parametros');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('procesos');
    }
};
