<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProcesoItem extends Model
{
    use HasFactory;

    
    protected $fillable = [
        'proceso_id',
        'nombre',
        'monto',
        'unidad',
        'tiempo_entrega',
        'forma_entrega',
        'lugar_entrega',
        'garantia',
    ];

    public function proceso()
    {
        return $this->belongsTo(Proceso::class);
    }

    public function adjuntos()
    {
        return $this->hasMany(ProcesoItemAdjunto::class, 'proceso_item_id');
    }
}
