<?php

namespace App\Models;

use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Parametro extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory, SoftDeletes, Userstamps;

    protected $fillable = ['tipo', 'nombre', 'codigo', 'valor', 'padre_id'];

    public function hijos()
    {
        return $this->hasMany(Parametro::class, 'padre_id');
    }

    public function padre()
    {
        return $this->belongsTo(Parametro::class, 'padre_id');
    }
       // Scope para obtener solo parámetros activos
    public function scopeActivos($query)
    {
        return $query->whereNull('deleted_at');
    }

    // Scope para filtrar por tipo
    public function scopePorTipo($query, $tipo)
    {
        return $query->where('tipo', $tipo);
    }

    // Obtener tipos únicos
    public static function getTipos()
    {
        return self::distinct()->pluck('tipo')->sort()->values();
    }

    public function scopeFormasAdjudicacionDe($query, $tipoContratacionId)
    {
        return $query->where('tipo', 'forma_adjudicacion')->where('padre_id', $tipoContratacionId);
    }
}
