<?php

namespace App\Models;

use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Empresa extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory, SoftDeletes, Userstamps;

    protected $fillable = [
        'nombre', 'nit', 'direccion_empresa', 'correo_empresa', 'contacto_empresa',
        'registro_seprec', 'representante_legal',
    ];

    public function contratos()
    {
        return $this->hasMany(Contrato::class);
    }
}
