<?php

namespace App\Livewire;

use Carbon\Carbon;
use App\Models\User;
use Livewire\Component;
use App\Models\Proceso as Contrato;
use App\Models\Parametro;
use App\Models\Seguimiento;
use Livewire\Attributes\Url;
use Livewire\WithPagination;
use PhpParser\Builder\Param;
use Livewire\WithFileUploads;

class SeguimientosComponent extends Component
{
    use WithPagination, WithFileUploads;

    // #[Url]
    public $contrato_id = '';

    #[Url]
    public $estado_id = '';

    #[Url]
    public $tecnico_id = '';

    #[Url]
    public $fecha_inicio = '';

    #[Url]
    public $fecha_fin = '';
    // #[Url]
    // public $page = 1;
    public $perPage = 10;
    public $seguimiento_id;
    public $fecha_seguimiento, $estado_seguimiento, $observacion, $adjuntos = [];

    public $estados_seguimiento, $tecnicos, $contratos;
    protected $listeners = ['eliminar' ];
    protected $rules = [
        'fecha_seguimiento' => 'required|date',
        'estado_seguimiento' => 'required|exists:estado_seguimientos,id',
        'observacion' => 'nullable|string',
        'adjuntos.*' => 'nullable|file|max:20480'
    ];

    public function mount()
    {
        $this->estados_seguimiento = Parametro::where('tipo', 'estado')->get();
        $this->tecnicos = User::whereHas('seguimientos')->get();
        $this->contratos = Contrato::has('seguimientos')->get();
    }

    public function render()
    {
        $seguimientos = Seguimiento::with(['contrato', 'estado', 'tecnico'])
            ->when($this->contrato_id, fn($q) => $q->where('contrato_id', $this->contrato_id))
            ->when($this->estado_id, fn($q) => $q->where('estado_id', $this->estado_id))
            ->when($this->tecnico_id, fn($q) => $q->where('created_by', $this->tecnico_id))
            ->when($this->fecha_inicio && $this->fecha_fin, function ($q) {
                $q->whereBetween('fecha_seguimiento', [Carbon::parse($this->fecha_inicio), Carbon::parse($this->fecha_fin)]);
            })
            ->orderBy('fecha_seguimiento', 'desc')
            ->paginate($this->perPage);

        return view('livewire.seguimientos-component', compact('seguimientos'));
    }

    // public function editar($id)
    // {
    //     $s = Seguimiento::findOrFail($id);
    //     $this->seguimiento_id = $s->id;
    //     $this->fecha_seguimiento = $s->fecha_seguimiento;
    //     $this->estado_seguimiento = $s->estado_seguimiento_id;
    //     $this->observacion = $s->observacion;
    //     $this->dispatch('abrir-modal');
    // }

    public function editar($id)
    {
        $this->dispatch('editSeguimiento', id: $id); // Evento hacia el otro componente
    }

    public function guardarSeguimiento()
    {
        $this->validate();

        $seguimiento = Seguimiento::findOrFail($this->seguimiento_id);
        $seguimiento->update([
            'fecha_seguimiento' => $this->fecha_seguimiento,
            'estado_seguimiento_id' => $this->estado_seguimiento,
            'observacion' => $this->observacion,
        ]);

        // Lógica opcional de subir archivos
        // ...

        $this->resetExcept(['contrato_id', 'estado_id', 'tecnico_id', 'fecha_inicio', 'fecha_fin']);
        $this->dispatch('cerrar-modal');
        $this->dispatch('alerta', text: 'Seguimiento actualizado correctamente');
    }

    public function eliminar($id)
    {
        Seguimiento::findOrFail($id)->delete();
        $this->dispatch('alerta', text: 'Seguimiento eliminado');
    }

    public function resetFiltros()
    {
        $this->reset('contrato_id', 'estado_id', 'tecnico_id', 'fecha_inicio', 'fecha_fin');
    }

    public function resetFechas()
    {
        $this->reset('fecha_inicio', 'fecha_fin');
    }

    public function updating($property)
    {
        if (in_array($property, ['contrato_id', 'estado_id', 'tecnico_id', 'fecha_inicio', 'fecha_fin'])) {
            $this->resetPage();
        }
    }
}
