<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;
use App\Models\Proceso as Contrato;
use App\Models\Asignacion;
use App\Models\Proceso;
use Livewire\Attributes\On;
use Livewire\WithPagination;

class AsignacionesComponent extends Component
{
    use WithPagination;
    public $perPage = 10;
    public $contratoFiltro = null;
    public $responsableFiltro = null;
    
    protected string $paginationTheme = 'bootstrap'; 
    public function updatingSearch()
    {
        $this->resetPage(); 
    }

    public function updatedContratoFiltro()
    {
        $this->resetPage();
    }

    public function updatedResposableFiltro()
    {
        $this->resetPage();
    }


    public function resetFiltros()
    {
        $this->reset([
            'contratoFiltro',
            'responsableFiltro',
        ]);
    }

    public function render()
    {
        $asignaciones = Asignacion::with(['proceso', 'responsable'])->withTrashed()
            ->when($this->contratoFiltro, fn($q) =>
                $q->where('proceso_id', $this->contratoFiltro)
            )
            ->when($this->responsableFiltro, fn($q) =>
                $q->where('responsable_id', $this->responsableFiltro)
            )
            ->latest()->paginate($this->perPage);

        return view('livewire.asignaciones-component', [
            'asignaciones' => $asignaciones,
            'contratos' => Proceso::all(),
            'responsables' => User::all(),
        ]);
    }

    #[On('confirmar-eliminacion')]
    public function eliminar($id)
    {
        $asignacion = Asignacion::find($id);

        if ($asignacion && !$asignacion->trashed()) {
            $asignacion->delete();
            $this->dispatch('alerta-eliminado'); // SweetAlert éxito
        }
    }

    #[\Livewire\Attributes\On('confirmar-restauracion')]
    public function restaurar($id)
    {
        $asignacion = Asignacion::withTrashed()->find($id);

        if ($asignacion && $asignacion->trashed()) {
            $asignacion->restore();
            $this->dispatch('alerta-restaurado');
        }
    }

}
