<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContratoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nuri' => 'required|string|max:255',
            // 'codigo_pac' => 'required|string|max:255',
            'fecha_ingreso' => 'required|date',
            'tipo_gasto_id' => 'required|exists:parametros,id',
            'objeto_contratacion' => 'required',
            // 'unidad_solicitante' => 'required|string|max:255',
            'normativa_id' => 'required|exists:parametros,id',
            'modalidad_id' => 'required|exists:parametros,id',
            'precio_referencial' => 'required|numeric',
            'fuente_organismo' => 'required|string|max:255',
            // 'numero_certificacion' => 'required|string|max:255',
            // 'fecha_autorizacion' => 'required|date',
            // 'nro_resolucion_autorizacion' => 'required|string|max:255',
            // 'fecha_resolucion_autorizacion' => 'required|date',
            // 'fecha_carta_adjudicacion' => 'required|date',
            // 'fecha_notificacion_adjudicacion' => 'required|date',
            // 'monto_adjudicado' => 'required|numeric',
            // 'empresa_adjudicada_id' => 'required|exists:empresas,id',
            // 'fecha_remision_juridica' => 'required|date',
            // 'fecha_retorno_juridica' => 'required|date',
            // 'tipo_contrato' => 'required|string|max:255',
            // 'fecha_contrato' => 'required|date',
            // 'monto_contrato' => 'required|numeric',
            // 'empresa_contratada_id' => 'required|exists:empresas,id',
            // 'plazo_entrega' => 'required|string|max:255',
            // 'fecha_estimada_entrega' => 'required|date',
            // 'cuce' => 'required|string|max:255',
            // 'registro_contraloria' => 'required|string|max:255',
            // 'fecha_informe_conformidad' => 'required|date',
            // 'fecha_registro_sicoes' => 'required|date',
            // 'situacion_id' => 'required|exists:parametros,id',
            // 'fecha_resimision_pago' => 'required|date',
            'recurrentes' => 'required|string|max:255',
            'tipo_adjunto_id' => 'required|exists:parametros,id',
            'entidad_id' => 'required|exists:parametros,id',
        ];
    }
}
