<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Empresa;
use setasign\Fpdi\Fpdi;
use App\Models\Contrato;
use App\Models\Parametro;
use Illuminate\Http\Request;
use App\Http\Requests\ContratoRequest;
use App\Models\Proceso;
use Barryvdh\Snappy\Facades\SnappyPdf;
use RealRashid\SweetAlert\Facades\Alert;
use setasign\Fpdi\PdfParser\StreamReader;
use Barryvdh\Snappy\Facades\SnappyPdf as PDF;

class ProcesoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('contratos.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $contrato = new Proceso();
        $tiposGastos = Parametro::where('tipo','tipo_gasto')->get();
        $objetosContratacion = Parametro::where('tipo','objetos_contratacion')->get();
        $normativas = Parametro::where('tipo','normativa')->get();
        $empresas = Empresa::all();
        $situaciones = Parametro::where('tipo','estado')->get();
        $tiposAdjuntos = Parametro::where('tipo','tipo_adjunto')->get();
        $entidades = Parametro::where('tipo','empresa')->get();
        $modalidades = Parametro::where('tipo','modalidad')->get();
        $responsables = User::all();
        return view('contratos.create', compact('contrato','tiposGastos','objetosContratacion','normativas','empresas','situaciones','tiposAdjuntos','entidades','modalidades','responsables') );
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ContratoRequest $request)
    {
        $contrato=Proceso::create($request->all());
        //ACtualizar asignación si el campo responsable_id está presente sincronizar con la tabla asignaciones
        if ($request->responsable_id != null) {
            $contrato->asignaciones()->syncWithoutDetaching([$request->responsable_id => ['fecha_asignacion' => now(),'observacion' => 'Asignación inicial']]);
        }
        Alert::success('Contrato registrado exitosamente.');
        return redirect()->route('contratos.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Proceso $contrato)
    {
        // $datos = [
        //     'titulo' => 'Reporte de Usuarios',
        //     'fecha' => now()->format('d/m/Y'),
        //     'usuarios' => \App\Models\User::all()
        // ];

        // $pdf = PDF::loadView('contratos.show', compact('contrato', 'datos'))
        //     ->setPaper('a4', 'portrait')
        //     ->setOption('margin-top', 10)
        //     ->setOption('margin-bottom', 10)
        //     ->setOption('margin-left', 10)
        //     ->setOption('margin-right', 10)
        //     ->setOption('enable-local-file-access', true);
        // return $pdf->stream('reporte_usuarios.pdf');

        $datos_contrato = Proceso::with('seguimientos.adjuntos')->findOrFail($contrato->id);

        // 1. Generar PDF base con Snappy (desde vista Blade)
        $pdfBase = SnappyPdf::loadView('procesos.show', compact('contrato'))->output();

        $pdf = new Fpdi();

        // 2. Importar PDF base desde cadena en memoria (stream)
        $pageCount = $pdf->setSourceFile(StreamReader::createByString($pdfBase));
        for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
            $templateId = $pdf->importPage($pageNo);
            $size = $pdf->getTemplateSize($templateId);
            $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
            $pdf->useTemplate($templateId);
        }

        // 3. Agregar los PDFs adjuntos (desde disco)
        foreach ($datos_contrato->seguimientos as $seguimiento) {
            foreach ($seguimiento->adjuntos as $adjunto) {
                $ruta = storage_path('app/public/' . $adjunto->archivo);
                if (file_exists($ruta) && strtolower(pathinfo($ruta, PATHINFO_EXTENSION)) === 'pdf') {
                    $pageCountAdj = $pdf->setSourceFile($ruta);
                    for ($pageNo = 1; $pageNo <= $pageCountAdj; $pageNo++) {
                        $templateId = $pdf->importPage($pageNo);
                        $size = $pdf->getTemplateSize($templateId);
                        $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
                        $pdf->useTemplate($templateId);
                    }
                }
            }
        }

        // 4. Enviar el PDF generado al navegador (inline)
        return response($pdf->Output('S'), 200, [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline; filename="Contrato_' . $contrato->id . '.pdf"',
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Proceso $contrato)
    {
        $tiposGastos = Parametro::where('tipo','tipo_gasto')->get();
        $objetosContratacion = Parametro::where('tipo','objetos_contratacion')->get();
        $normativas = Parametro::where('tipo','normativa')->get();
        $empresas = Empresa::all();
        $situaciones = Parametro::where('tipo','estado')->get();
        $tiposAdjuntos = Parametro::where('tipo','tipo_adjunto')->get();
        $entidades = Parametro::where('tipo','empresa')->get();
        $modalidades = Parametro::where('tipo','modalidad')->get();
        $responsables = User::all();
        return view('contratos.edit', compact('contrato','tiposGastos','objetosContratacion','normativas','empresas','situaciones','tiposAdjuntos','entidades','modalidades','responsables') );
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Proceso $contrato)
    {
        //dd($request->all());
        $contrato->update($request->all());
        //controla si la primera asignacion de responsable cambio al momento
        if ($request->filled('responsable_id')) {
            $nuevoResponsableId = $request->responsable_id;
            $actualResponsable = optional($contrato->asignaciones->first())->responsable_id;

            if ($nuevoResponsableId != $actualResponsable) {
                // eliminar asignación anterior si existe
                if ($actualResponsable) {
                    $contrato->asignaciones()->detach($actualResponsable);
                }
                // agregar nueva asignación
                $contrato->asignaciones()->syncWithoutDetaching([
                    $nuevoResponsableId => [
                        'fecha_asignacion' => now(),
                        'observacion' => 'Asignación actualizada'
                    ]
                ]);
            }
        }
        Alert::success('Contrato actualizado exitosamente.');
        return redirect()->route('contratos.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Proceso $contrato)
    {
        $contrato->delete();
        // Eliminar las asignaciones relacionadas
        $contrato->asignaciones()->delete();
        Alert::success('Contrato eliminado exitosamente.');
        return redirect()->route('procesos-contratacion.index');
    }
}
